HLTP1 ;AISC/SAW-Transaction Processor Module (Cont'd) ;09/13/2006
 ;;1.6;HEALTH LEVEL SEVEN;**34,47,91,133**;Oct 13, 1995;Build 13
 ;Per VHA Directive 2004-038, this routine should not be modified.
GENACK(HLMIDA,HLMTIENA,HLEIDS,HLARYTYP,HLFORMAT,HLRESLTA,HLP) ;
 ;Entry point to generate an acknowledgement message
 ;
 ;This is a subroutine call with parameter passing.  It returns a value
 ;in the variable HLRESLTA of null if no error occurs, or the following
 ;two piece value if an error occurs:  error code^error description
 ;
 ;Required Input Parameters
 ;    HLMIDA = Message ID of aknowledgement message
 ;  HLMTIENA = IEN of entry in Message Text file where acknowledgement
 ;               message will be stored
 ;    HLEIDS = IEN of subscriber protocol from the Protocol file
 ;  HLARYTYP = Array type.  One of the following codes:
 ;               LM = local array containing a single message
 ;               LB = local array containig a batch of messages
 ;               GM = global array containing a single message
 ;               GB = global array containing a batch of messages
 ;  HLFORMAT = Format of array, 1 for pre-formatted in HL7 format,
 ;               otherwise 0
 ;NOTE:  The variable HLRESLTA must be passed by reference
 ;  HLRESLTA = The variable that will be returned to the calling
 ;               application as descibed above
 ;Optional Parameters
 ;  HLP("SECURITY") = A 1 to 40 character string
 ;  HLP("GROUTINE") = The M code to execute to generate the
 ;                      acknowledgement message
 ;     HLP("MSACK") = 1 if this acknowledgment message is being
 ;                      generated by the Messaging System
 ; HLP("NAMESPACE") = Passed in by application namespace - HL*1.6*91
 ;
 S HLRESLTA=""
 ;
 ;Check for required parameters
 I '$G(HLMIDA)!('$G(HLMTIENA))!('$G(HLEIDS))!($G(HLARYTYP)']"")!($G(HLFORMAT)']"") S HLRESLTA="7^"_$G(^HL(771.7,7,0))_" at GENACK^HLTP1 entry point" G EXIT
 ;Extract data from file 101 and store in separate variables
 D EVENT^HLUTIL1(HLEIDS,770,.HLN)
 S HLSAN=$P($G(^HL(771,+$P(HLN(770),"^",2),0)),"^"),HLQ=""""""
 S HLP("MSGTYPE")=$E(HLARYTYP,2)
 ;Update zero node of Message Text file
 D UPDATE^HLTF0(HLMTIENA,HLP("MTIENS"),"O",HLEIDS,"",$P(HLN(770),"^",2),"",$P($G(^HL(772,HLP("MTIENS"),0)),"^",8),"",.HLP)
 ;Update status to Being Generated
 D STATUS^HLTF0(HLMTIENA,8)
 ;Check that local/global array exists and store in Message Text file
 ; if pre-compiled
 I HLFORMAT D  I (+$G(HLRESLTA)) D STATUS^HLTF0(HLMTIENA,4,+HLRESLTA) G EXIT
 .I $E(HLARYTYP)="G" D
 ..I $O(^TMP("HLA",$J,0))']"" S HLRESLTA="8^"_$G(^HL(771.7,8,0)) Q
 ..D MERGE^HLTF1("G",HLMTIENA,"HLA")
 .I $E(HLARYTYP)="L" D
 ..I $O(HLA("HLA",0))']"" S HLRESLTA="8^"_$G(^HL(771.7,8,0)) Q
 ..D MERGE^HLTF1("L",HLMTIENA,"HLA")
 ;If array is not pre-compiled, call message generation routine
 I 'HLFORMAT N HLERR D  I $D(HLERR) S HLRESLTA="9^"_HLERR D STATUS^HLTF0(HLMTIENA,4,9,HLERR) G EXIT
 .S HLP("GROUTINE")=HLP("GROUTINE")_"("_HLMIDA_","_HLMTIENA_","_HLQ_HLARYTYP_HLQ_","_HLSAN_","_$P($G(^HL(771.2,$P(HLN(770),"^",3),0)),"^")_","_$P($G(^HL(779.001,$P(HLN(770),"^",4),0)),"^")_","_HLQ_$TR($P(HLN(770),"^",6),"id","ID")_HLQ_")"
 .X HLP("GROUTINE")
 ;Invoke communication server module to send message to subscribers
 K HLARYTYP,HLFORMAT,HLQ
 D SENDACK^HLCS(HLMTIENA,HLP("EID"),HLEIDS,.HLRESLTA) ;,$G(HLP("MSACK")))
EXIT K HLQ,HLSAN
 Q
